#include <math.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>

#include <FL/Fl.H>
#include <FL/Fl_Overlay_Window.H>
#include <FL/Fl_Light_Button.H>
#include "../Fl_Cartesian.H"
#include <FL/fl_draw.H>

double plot[4096];

const double PI = 3.1416;
const double MIN_FREQ = 100;
const double MAX_FREQ = 4000;
const double FREQ_COEF = 1.15;

Ca_X_Axis *sig_i;
Ca_Y_Axis *sig_q;
Ca_X_Axis *eq_x;
Ca_Y_Axis *eq_y;

Ca_Canvas *canvas1;
Ca_Canvas *canvas2;

Ca_Line *rel = NULL;
double re_plot[100];

void type_callback(Fl_Widget *, void *)
{
}

void next_data(void *)
{
    int i;
    float x;
    float y;
    
    for (i = 0;  i < 100;  i++)
    {
        x = rand() & 0xFFFF;
        y = rand() & 0xFFFF;
        x /= (65536.0/6.0);
        y /= (65536.0/6.0);
        new Ca_Point(x, y, FL_GREEN);
    }
    Fl::add_timeout(.1, next_data);
};


int main(int argc, char ** argv) 
{
    char buf[132 + 1];
    float x;
    float y;
    int i;
    FILE *fin;
    Fl_Double_Window *w = new Fl_Double_Window(845, 400, "QAM space");
	Fl_Group *c1 = new Fl_Group(0, 0, 410, 400);
	Fl_Group *c2 = new Fl_Group(415, 0, 430, 400);

    c1->box(FL_DOWN_BOX);
    c1->align(FL_ALIGN_TOP | FL_ALIGN_INSIDE);
    canvas1 = new Ca_Canvas(80, 35, 300, 300, "QAM space");
    canvas1->box(FL_PLASTIC_DOWN_BOX);
    canvas1->color(7);
    canvas1->align(FL_ALIGN_TOP);
    Fl_Group::current()->resizable(canvas1);
    canvas1->border(15);

    sig_i = new Ca_X_Axis(85, 337, 295, 30, "I");
    sig_i->align(FL_ALIGN_BOTTOM);
    sig_i->minimum(-11.0);
    sig_i->maximum(11.0);
    sig_i->label_format("%g");
    sig_i->minor_grid_color(fl_gray_ramp(20));
    sig_i->major_grid_color(fl_gray_ramp(15));
    sig_i->label_grid_color(fl_gray_ramp(10));
	sig_i->grid_visible(CA_LABEL_GRID | CA_ALWAYS_VISIBLE);
	sig_i->minor_grid_style(FL_DOT);
    sig_i->major_step(5);
    sig_i->label_step(1);
	sig_i->axis_color(FL_BLACK);
	sig_i->axis_align(CA_BOTTOM | CA_LINE);

    sig_q = new Ca_Y_Axis(40, 30, 38, 295, "Q");
    sig_q->align(FL_ALIGN_LEFT);
    sig_q->minimum(-11.0);
    sig_q->maximum(11.0);
    sig_q->minor_grid_color(fl_gray_ramp(20));
    sig_q->major_grid_color(fl_gray_ramp(15));
    sig_q->label_grid_color(fl_gray_ramp(10));
	//sig_q->grid_visible(CA_MINOR_TICK | CA_MAJOR_TICK | CA_LABEL_GRID | CA_ALWAYS_VISIBLE);
	sig_q->grid_visible(CA_LABEL_GRID | CA_ALWAYS_VISIBLE);
	sig_q->minor_grid_style(FL_DOT);
    sig_q->major_step(5);
    sig_q->label_step(1);
    sig_q->current();

    c1->end();

    c2->box(FL_DOWN_BOX);
    c2->align(FL_ALIGN_TOP | FL_ALIGN_INSIDE);
    c2->current();
    canvas2 = new Ca_Canvas(500, 35, 300, 300, "Equalizer");
    canvas2->box(FL_PLASTIC_DOWN_BOX);
    canvas2->color(7);
    canvas2->align(FL_ALIGN_TOP);
    Fl_Group::current()->resizable(canvas2);
    canvas2->border(15);

    eq_x = new Ca_X_Axis(505, 337, 295, 30, "Symbol");
    eq_x->align(FL_ALIGN_BOTTOM);
    eq_x->minimum(0.0);
    eq_x->maximum(11.0);
    eq_x->label_format("%g");
    eq_x->minor_grid_color(fl_gray_ramp(20));
    eq_x->major_grid_color(fl_gray_ramp(15));
    eq_x->label_grid_color(fl_gray_ramp(10));
	eq_x->grid_visible(CA_LABEL_GRID | CA_ALWAYS_VISIBLE);
	eq_x->minor_grid_style(FL_DOT);
    eq_x->major_step(5);
    eq_x->label_step(1);
	eq_x->axis_align(CA_BOTTOM | CA_LINE);
    eq_x->current();

    eq_y = new Ca_Y_Axis(460, 30, 38, 295, "Amp");
    eq_y->align(FL_ALIGN_LEFT);
    eq_y->minimum(-11.0);
    eq_y->maximum(11.0);
    eq_y->minor_grid_color(fl_gray_ramp(20));
    eq_y->major_grid_color(fl_gray_ramp(15));
    eq_y->label_grid_color(fl_gray_ramp(10));
	eq_y->grid_visible(CA_LABEL_GRID | CA_ALWAYS_VISIBLE);
	eq_y->minor_grid_style(FL_DOT);
    eq_y->major_step(5);
    eq_y->label_step(1);
    eq_y->current();

    c2->end();

    w->end();
    w->show();

    canvas1->current(canvas1);
    for (i = 0;  i < 10;  i++)
    {
        re_plot[2*i] = i/2.0;
        re_plot[2*i + 1] = i*i;
    }
    rel = new Ca_Line(20, re_plot, 0, 0, FL_BLUE, CA_NO_POINT);
    canvas2->current(canvas2);
    for (i = 0;  i < 10;  i++)
    {
        re_plot[2*i] = i/2.0;
        re_plot[2*i + 1] = i*i;
    }
    rel = new Ca_Line(20, re_plot, 0, 0, FL_RED, CA_NO_POINT);

    //Fl::add_timeout(0, next_data);
	Fl::check();
    fin = fopen("points.txt", "r");
    while (fgets(buf, 132, fin))
    {
        sscanf(buf, "%*d [ %f, %f", &x, &y);
#if 0
        new Ca_Point(x, y, FL_BLACK);
#endif
        Fl::check();
    }
    fclose(fin);
    Fl::run();
	return 0;
};
